﻿Type.registerNamespace("View");

var g_iMaxLength = "1";

// Constructor
View.NormalXiaLianView = function(element) {

    View.NormalXiaLianView.initializeBase(this, [element]);

    //delcalre event delegates.
    this.m_dgXLMouseOverDelegate = null;
    this.m_dgXLKeyDownDelegate = null;
    this.m_dgXLKeyUpDelegate = null;
    this.m_dgXLChangeDelegate = null;
    this.m_dgXLFocusDelegate = null;
    this.m_dgXLBlurDelegate = null;
    this.m_dgXLClickDelegate = null;
    this.m_dgSLMouseOverDelegate = null;
    this.m_dgSLKeyDownDelegate = null;
    this.m_dgSLKeyUpDelegate = null;
    this.m_dgSLChangeDelegate = null;
    this.m_dgSLFocusDelegate = null;
    this.m_dgSLBlurDelegate = null;
    this.m_dgSLClickDelegate = null;
    
    this.m_rgCurResult = null;
    this.m_sShanglian = null;
    this.m_sXialian = "";
    
    this.m_divSLwrapper = $get("SLwrapper");
    this.m_divXLwrapper = $get("XLwrapper");
    this.m_sPrefixNormal = "nor";
    
    //an array store normal xialian result
    this.m_rgXialianNormalCandidates = null;
    $create(View.CandidateList, {purpose: "XialianNormal", groupSize: 10},  null ,null, $get("divNormalView"));
    //an element to contain xialian candidate after render.
    this.m_candidatelist = $find("divNormalView");
}
View.NormalXiaLianView.prototype = 
{
    // Store the current result and construct Normal Xialian view in the DOM
    set_result: function(rgResult)
    {
        this.m_rgCurResult = rgResult;
        this.constructNormalXiaLianView(rgResult);
        this.set_display(true);
    },
    //set style of display.
    set_display: function (fDisplayed)
    {
        var sDisplay = fDisplayed ? "" : "none";
        this.get_element().style.display = sDisplay;
    },
    //get shanglian text.   
    get_Shanglian: function()
    {
        return this.m_sShanglian;
    },
    //get xialian text.
    set_Xialian: function(xialian)
    {
        this.m_sXialian = xialian;
    },
    //clear xialian both element and array.
    clear: function()
    {
        this.m_candidatelist.clear();
        this.m_rgCurResult=null;
        this.m_rgXialianNormalCandidates=null;
    },
    //event handler for candidate's click event
    add_click: function(handler) 
    {
        this.m_candidatelist.add_click(handler);
    },
    
    remove_click: function(handler) 
    {
        this.m_candidatelist.remove_click(handler);
    },
    //event handler for candidate's mouse over event
    add_hover: function(handler) 
    {
        this.m_candidatelist.add_hover(handler);
    },
    
    remove_hover: function(handler) 
    {
        this.m_candidatelist.remove_hover(handler);
    },
    //event handler for candidate's mouse out event
    add_unhover: function(handler) 
    {
        this.m_candidatelist.add_unhover(handler);
    },
    
    remove_unhover: function(handler) 
    {
        this.m_candidatelist.remove_unhover(handler);
    },
    //event handler for xialian input box mouse over event
    add_XLmouseover: function(handler) 
    {
        this.get_events().addHandler("XLmouseover", handler);
    },
    
    remove_XLmouseover: function(handler) 
    {
        this.get_events().removeHandler("XLmouseover", handler);
    },
    //event handler for xialian input box's key down event
    add_XLkeydown: function(handler) 
    {
        this.get_events().addHandler("XLkeydown", handler);
    },
    
    remove_XLkeydown: function(handler) 
    {
        this.get_events().removeHandler("XLkeydown", handler);
    },
    //event handler for xialian input box's key up event
    add_XLkeyup: function(handler) 
    {
        this.get_events().addHandler("XLkeyup", handler);
    },
    
    remove_XLkeyup: function(handler) 
    {
        this.get_events().removeHandler("XLkeyup", handler);
    },
    //event handler for xialian input box's change event
    add_XLchange: function(handler) 
    {
        this.get_events().addHandler("XLchange", handler);
    },
    
    remove_XLchange: function(handler) 
    {
        this.get_events().removeHandler("XLchange", handler);
    },
    //event handler for xialian input box's focus event
    add_XLfocus: function(handler) 
    {
        this.get_events().addHandler("XLfocus", handler);
    },
    
    remove_XLfocus: function(handler) {
        this.get_events().removeHandler("XLfocus", handler);
    },
    //event handler for xialian input box's blur event
    add_XLblur: function(handler) 
    {
        this.get_events().addHandler("XLblur", handler);
    },
    
    remove_XLblur: function(handler) 
    {
        this.get_events().removeHandler("XLblur", handler);
    },
    //event handler for xialian inputbox's click event
    add_XLclick: function(handler) 
    {
        this.get_events().addHandler("XLclick", handler);
    },
    
    remove_XLclick: function(handler) 
    {
        this.get_events().removeHandler("XLclick", handler);
    },
    //event handler for shanglian inputbox's mouse over event
    add_SLmouseover: function(handler) 
    {
        this.get_events().addHandler("SLmouseover", handler);
    },
    
    remove_SLmouseover: function(handler) 
    {
        this.get_events().removeHandler("SLmouseover", handler);
    },
    //event handler for shanglian inputbox's keydown event
    add_SLkeydown: function(handler) 
    {
        this.get_events().addHandler("SLkeydown", handler);
    },
    
    remove_SLkeydown: function(handler) 
    {
        this.get_events().removeHandler("SLkeydown", handler);
    },
    //event handler for shanglian inputbox's keyup event
    add_SLkeyup: function(handler) 
    {
        this.get_events().addHandler("SLkeyup", handler);
    },
    
    remove_SLkeyup: function(handler) 
    {
        this.get_events().removeHandler("SLkeyup", handler);
    },
    //event handler for shanglian inputbox's textchange event
    add_SLchange: function(handler) 
    {
        this.get_events().addHandler("SLchange", handler);
    },
    
    remove_SLchange: function(handler) 
    {
        this.get_events().removeHandler("SLchange", handler);
    },
    //event handler for shanglian inputbox's focus event
    add_SLfocus: function(handler) 
    {
        this.get_events().addHandler("SLfocus", handler);
    },
    remove_SLfocus: function(handler) 
    {
        this.get_events().removeHandler("SLfocus", handler);
    },
    //event handler for shanglian inputbox's blur event
    add_SLblur: function(handler) 
    {
        this.get_events().addHandler("SLblur", handler);
    },
    
    remove_SLblur: function(handler) 
    {
        this.get_events().removeHandler("SLblur", handler);
    },
    //event handler for shanglian inputbox's click event
    add_SLclick: function(handler)
    {
        this.get_events().addHandler("SLclick", handler);
    },
    
    remove_SLclick: function(handler) 
    {
        this.get_events().removeHandler("SLclick", handler);
    },

    // Release resources before control is disposed.
    dispose: function() 
    {
        if(!this.m_sShanglian)
        {
            return;
        }
        //remove event handler from shanglian and xialian input box
        for(var i=0; i<this.m_sShanglian.length; i++)
        {
	        var sInputSLid = this.m_sPrefixNormal + gConst_ShangLian + i;
	        var txtshanglianinput = $get(sInputSLid);
	        if(txtshanglianinput)
	        {
                Sys.UI.DomEvent.removeHandler(txtshanglianinput, "mouseover", this.m_dgSLMouseOverDelegate);
                Sys.UI.DomEvent.removeHandler(txtshanglianinput, "keydown", this.m_dgSLKeyDownDelegate);
                Sys.UI.DomEvent.removeHandler(txtshanglianinput, "keyup", this.m_dgSLKeyUpDelegate);
                Sys.UI.DomEvent.removeHandler(txtshanglianinput, "change", this.m_dgSLChangeDelegate);
                Sys.UI.DomEvent.removeHandler(txtshanglianinput, "focus", this.m_dgSLFocusDelegate);
                Sys.UI.DomEvent.removeHandler(txtshanglianinput, "blur", this.m_dgSLBlurDelegate);
            }
            var sInputXLid = this.m_sPrefixNormal + gConst_XiaLian + i;
            var txtxialianinput = $get(sInputXLid);
	        if(txtxialianinput)
	        {
                Sys.UI.DomEvent.removeHandler(txtxialianinput, "mouseover", this.m_dgXLMouseOverDelegate);
                Sys.UI.DomEvent.removeHandler(txtxialianinput, "keydown", this.m_dgXLKeyDownDelegate);
                Sys.UI.DomEvent.removeHandler(txtxialianinput, "keyup", this.m_dgXLKeyUpDelegate);
                Sys.UI.DomEvent.removeHandler(txtxialianinput, "change", this.m_dgXLChangeDelegate);
                Sys.UI.DomEvent.removeHandler(txtxialianinput, "focus", this.m_dgXLFocusDelegate);
                Sys.UI.DomEvent.removeHandler(txtxialianinput, "blur", this.m_dgXLBlurDelegate);
            }
        }
        delete this.m_dgXLMouseOverDelegate;
        delete this.m_dgXLKeyDownDelegate;
        delete this.m_dgXLKeyUpDelegate;
        delete this.m_dgXLChangeDelegate;
        delete this.m_dgXLFocusDelegate;
        delete this.m_dgXLBlurDelegate;
        delete this.m_dgSLMouseOverDelegate;
        delete this.m_dgSLKeyDownDelegate;
        delete this.m_dgSLKeyUpDelegate;
        delete this.m_dgSLChangeDelegate;
        delete this.m_dgSLFocusDelegate;
        delete this.m_dgSLBlurDelegate;
        View.NormalXiaLianView.callBaseMethod(this, "dispose");
    },

    //create event delegete in initialize funtion
    initialize: function() {
        
        if (this.m_dgXLMouseOverDelegate === null) {
            this.m_dgXLMouseOverDelegate = Function.createDelegate(this, this._XLmouseoverHandler);
        }
        
        if (this.m_dgXLKeyDownDelegate === null) {
            this.m_dgXLKeyDownDelegate = Function.createDelegate(this, this._XLkeydownHandler);
        }

        if (this.m_dgXLKeyUpDelegate === null) {
            this.m_dgXLKeyUpDelegate = Function.createDelegate(this, this._XLkeyupHandler);
        }
        
        if (this.m_dgXLChangeDelegate === null) {
            this.m_dgXLChangeDelegate = Function.createDelegate(this, this._XLchangeHandler);
        }

        if (this.m_dgXLFocusDelegate === null) {
            this.m_dgXLFocusDelegate = Function.createDelegate(this, this._XLfocusHandler);
        }
        
        if (this.m_dgXLBlurDelegate === null) {
            this.m_dgXLBlurDelegate = Function.createDelegate(this, this._XLblurHandler);
        }
        
        if (this.m_dgXLClickDelegate === null) {
            this.m_dgXLClickDelegate = Function.createDelegate(this, this._XLclickHandler);
        }
        
        if (this.m_dgSLMouseOverDelegate === null) {
            this.m_dgSLMouseOverDelegate = Function.createDelegate(this, this._SLmouseoverHandler);
        }
        
        if (this.m_dgSLKeyDownDelegate === null) {
            this.m_dgSLKeyDownDelegate = Function.createDelegate(this, this._SLkeydownHandler);
        }

        if (this.m_dgSLKeyUpDelegate === null) {
            this.m_dgSLKeyUpDelegate = Function.createDelegate(this, this._SLkeyupHandler);
        }
        
        if (this.m_dgSLChangeDelegate === null) {
            this.m_dgSLChangeDelegate = Function.createDelegate(this, this._SLchangeHandler);
        }

        if (this.m_dgSLFocusDelegate === null) {
            this.m_dgSLFocusDelegate = Function.createDelegate(this, this._SLfocusHandler);
        }
        
        if (this.m_dgSLBlurDelegate === null) {
            this.m_dgSLBlurDelegate = Function.createDelegate(this, this._SLblurHandler);
        }
        
        if (this.m_dgSLClickDelegate === null) {
            this.m_dgSLClickDelegate = Function.createDelegate(this, this._SLclickHandler);
        }
        
        View.NormalXiaLianView.callBaseMethod(this, "initialize");

    },
    // These internal defined handlers are used to 
    // create corresponding delegates. In this pattern, we
    // can decouple the control initialization logic from client
    // custom event handler assignment.
    _XLmouseoverHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLmouseover");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLkeydownHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLkeydown");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLkeyupHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLkeyup");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLchangeHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLchange");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLfocusHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLfocus");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLblurHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLblur");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLclickHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLclick");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLmouseoverHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLmouseover");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLkeydownHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLkeydown");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLkeyupHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLkeyup");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLchangeHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLchange");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLfocusHandler: function(event)
    {
        var h = this.get_events().getHandler("SLfocus");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLblurHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLblur");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLclickHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLclick");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    /// <summary>
	/// This method is to get the element who invoked current evnet.
	/// </summary>
    /// <accessibility>private</accessibility>
	/// <param name="evt">event object</param>
	/// <return value>If success, it will return DOM element</return value>
    _getSender: function(event)
    {
        var target = event.target;              // DOM standard event model
        if (!target)
        {
            target = event.srcElement;          // IE event model
        }
        
        return target;
    },

	/// This method is to set one shanglian/xialian word according to candidate id .
	/// </summary>
    /// <accessibility>public</accessibility> 
    /// <param name="candidateID">ID of the candidate</param>
    /// <param name="lian">shanglian or xialian</param>
    /// <param name="content">content to set</param>
    setNormalSelectedByID: function(candidateID, lian, content)
    {
        if($get(this.m_sPrefixNormal + lian + candidateID)==null) 
        {
            return;
        }
	    $get(this.m_sPrefixNormal + lian + candidateID ).value = content;

    },  
      
    /// <summary>
	/// This method is to set candidate id according to user's selection.
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="iSelectedCandidateId">iSelectedCandidateId represent which candidate is selected</param>
    setSelectedCandidateId: function(iSelectedCandidateId)
    {
        return this.m_candidatelist.setSelectedCandidateId(iSelectedCandidateId);
    },
    
    /// <summary>
	/// This method is to set the style of display and set the position of the selected panel.
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="rgResult">result of candidate array</param>
    constructNormalXiaLianView: function(rgResult)
    {
        //The result should not be null
        if(!rgResult) 
        {
            return;
        }
        //clear xialian result generate in last time.
        this.clear();
        //XiaLian result contains two part, original xialian and common xialian
        //put two parts together into a table
        if (rgResult.XialianWellKnownSets)
        {
            //arraySegmentPattern is used to stored the segment pattern of each candidate.
            var arraySegmentPattern = new Array();
            if(rgResult.XialianSystemGeneratedSets != null)
            {
                for(var i=0; i<rgResult.XialianSystemGeneratedSets.length; i++)
                {
                    arraySegmentPattern[rgResult.XialianSystemGeneratedSets[i].SegmentPattern] = i;
                }
            }
            for(var i=0; i<rgResult.XialianWellKnownSets.length;i++)
            {
                //if a candidate has not its own segment pattern, set it to 0.
                //Otherwise, leave as it is.
                var segmentationIndexOfCurrentWellKnownSet = arraySegmentPattern[rgResult.XialianWellKnownSets[i].SegmentPattern] == null ? "0" :
                        arraySegmentPattern[rgResult.XialianWellKnownSets[i].SegmentPattern];
                this.m_rgXialianNormalCandidates = rgResult.XialianWellKnownSets[i];
                //add the result to candidate list.
                for(var j=0;j<rgResult.XialianWellKnownSets[i].XialianCandidates.length;j++)
                {
                    this.m_candidatelist.addCandidate(rgResult.XialianWellKnownSets[i].XialianCandidates[j], segmentationIndexOfCurrentWellKnownSet);
                }
            }
        }
        if (rgResult.XialianSystemGeneratedSets)
        {
            for(var i=0; i<rgResult.XialianSystemGeneratedSets.length; i++)
            {
                //m_rgXialianNormalCandidates is used to stored the segment pattern index.
                this.m_rgXialianNormalCandidates = rgResult.XialianSystemGeneratedSets[i].XialianCandidates;
                for(var j=0;j<rgResult.XialianSystemGeneratedSets[i].XialianCandidates.length;j++)
                {
                    //add the result to candidate list.
                    this.m_candidatelist.addCandidate(rgResult.XialianSystemGeneratedSets[i].XialianCandidates[j], i);
                }
            }
        }
    },
    
    /// <summary>
	/// This method is to construct shanglian and xialian input box and attach events.
	/// </summary>
    /// <accessibility>private</accessibility>
    GenerateNormalSelected: function()
    {
        
        var tblSL = document.createElement("table");
        tblSL.style.cssText = "width:304px;";
        var tbdSL = document.createElement("TBODY");
        tblSL.appendChild(tbdSL);
        var trSL = document.createElement("tr");
        tbdSL.appendChild(trSL);
        
        var tblXL = document.createElement("table");
        tblXL.style.cssText = "width:304px;";
        var tbdXL = document.createElement("TBODY");
        tblXL.appendChild(tbdXL);
        var trXL = document.createElement("tr");
        tbdXL.appendChild(trXL);
        var tdwidth = parseInt(300/this.m_sShanglian.length)+"px";
        
        for(var i=0; i<this.m_sShanglian.length; i++)
        {
            //construct a TD to contain a shanglian word.
            var tdSL = document.createElement("td");
            //the last cell need list separator
            if(i < this.m_sShanglian.length - 1)
                tdSL.className= "TDwithbar";
            tdSL.style.width=tdwidth;
            tdSL.style.textAlign = "center";
            //create a textbox
            var txtinputshanglian;
            txtinputshanglian = document.createElement("input");
            txtinputshanglian.type = "text";
            txtinputshanglian.id = this.m_sPrefixNormal + gConst_ShangLian + i;
            txtinputshanglian.value = this.m_sShanglian.charAt(i).replace(" ","");
            txtinputshanglian.maxLength = g_iMaxLength;
            txtinputshanglian.className = "transparantInput";
            //attach event to textbox
            Sys.UI.DomEvent.addHandler(txtinputshanglian,"mouseover",this.m_dgSLMouseOverDelegate);
            Sys.UI.DomEvent.addHandler(txtinputshanglian,"focus",this.m_dgSLFocusDelegate);
            Sys.UI.DomEvent.addHandler(txtinputshanglian,"blur",this.m_dgSLBlurDelegate);
            Sys.UI.DomEvent.addHandler(txtinputshanglian,"change",this.m_dgSLChangeDelegate);
            Sys.UI.DomEvent.addHandler(txtinputshanglian,"keydown",this.m_dgSLKeyDownDelegate);
            Sys.UI.DomEvent.addHandler(txtinputshanglian,"keyup",this.m_dgSLKeyUpDelegate);
            Sys.UI.DomEvent.addHandler(tdSL,"click",this.m_dgSLClickDelegate);
            
            tdSL.appendChild(txtinputshanglian); 
            trSL.appendChild(tdSL); 
            
            //construct a TD to contain a xialian word.
            var tdXL = document.createElement("td");
            //the last cell need list separator
            if( i < this.m_sShanglian.length - 1)
                tdXL.className= "TDwithbar";
            tdXL.style.width=tdwidth;
            tdXL.style.textAlign = "center";
            //create a textbox
            var txtinputxialian;
            txtinputxialian = document.createElement("input");
            txtinputxialian.type = "text";
            txtinputxialian.id = this.m_sPrefixNormal + gConst_XiaLian + i;
            txtinputxialian.value = this.m_sXialian.charAt(i).replace(" ","");//$get( "prev" + gConst_XiaLian+ i).value;
            txtinputxialian.maxLength = g_iMaxLength;
            txtinputxialian.className = "transparantInput";
            //attach event to textbox
            Sys.UI.DomEvent.addHandler(txtinputxialian,"mouseover",this.m_dgXLMouseOverDelegate);
            Sys.UI.DomEvent.addHandler(txtinputxialian,"focus",this.m_dgXLFocusDelegate);
            Sys.UI.DomEvent.addHandler(txtinputxialian,"blur",this.m_dgXLBlurDelegate);
            Sys.UI.DomEvent.addHandler(txtinputxialian,"change",this.m_dgXLChangeDelegate);
            Sys.UI.DomEvent.addHandler(txtinputxialian,"keydown",this.m_dgXLKeyDownDelegate);
            Sys.UI.DomEvent.addHandler(txtinputxialian,"keyup",this.m_dgXLKeyUpDelegate);
            Sys.UI.DomEvent.addHandler(tdXL,"click",this.m_dgXLClickDelegate);
            
            tdXL.appendChild(txtinputxialian); 
            trXL.appendChild(tdXL); 
        }
        //delete the old content, if necessary, and append the table to the outer DIV
        if(this.m_divSLwrapper.firstChild!=null)
        {		                                       
            this.m_divSLwrapper.removeChild(this.m_divSLwrapper.firstChild);
        }
        this.m_divSLwrapper.appendChild(tblSL);
        //delete the old content, if necessary, and append the table to the outer DIV
        if(this.m_divXLwrapper.firstChild!=null)
        {		                                       
            this.m_divXLwrapper.removeChild(this.m_divXLwrapper.firstChild);
        }
        this.m_divXLwrapper.appendChild(tblXL);
    }
}
View.NormalXiaLianView.registerClass("View.NormalXiaLianView", Sys.UI.Control);

View.AdvXiaLianView = function(element) 
{

    View.AdvXiaLianView.initializeBase(this, [element]);
    //delcalre event delegates.
    this.m_dgClickCandidateDelegate = null;
    this.m_dgHoverCandidateDelegate = null;
    this.m_dgUnhoverCandidateDelegate = null;
    this.m_dgClickSelectedPanelDelegate = null;
    this.m_dgHoverSelectedPanelDelegate = null;
    this.m_dgUnhoverSelectedPanelDelegate = null;
    this.m_dgClickSelectedPanelTitleDelegate = null;
    
    this.m_dgXLMouseOverDelegate = null;
    this.m_dgXLKeyDownDelegate = null;
    this.m_dgXLKeyUpDelegate = null;
    this.m_dgXLChangeDelegate = null;
    this.m_dgXLFocusDelegate = null;
    this.m_dgXLBlurDelegate = null;
    this.m_dgXLClickDelegate = null;
    this.m_dgSLMouseOverDelegate = null;
    this.m_dgSLKeyDownDelegate = null;
    this.m_dgSLKeyUpDelegate = null;
    this.m_dgSLChangeDelegate = null;
    this.m_dgSLFocusDelegate = null;
    this.m_dgSLBlurDelegate = null;
    this.m_dgSLClickDelegate = null;
    //an array store normal xialian result
    this.m_rgCurResult = null;
    //record the current selected id in dropdown panel. The default value is 0.
    this.m_iSelectedID = 0;
    this.m_sShanglian = "";
    this.m_sXialian = "";
    //record weither the current selected id in dropdown panel has been changed. The default value is false.
    this.m_fSegmentPatternChanged = false;
    //an DIV to contain candidate view
    this.m_divcandidateView = $get("divCandView");
    //an DIV to contain dropdown panel view
    this.m_divSelectedPanelView = $get("divSelectionView");
    this.m_divSelectpanelContent = $get("selectpanel");
    //an DIV to contain shanglian input box
    this.m_divShanglianAdvancedWrapper = $get("SLAdvwrapper");
    //an DIV to contain xialian input box.
    this.m_divXialianAdvancedWrapper = $get("XLAdvwrapper");
    //ID of candidate table
    this.m_sXialianTableID = "Adv_XiaLian_table";
    //ID of tbody in the candidate table.
    this._CONST_CAND_TBODY = "cand_tbody";
    this.m_sPrefixAdvance = "adv";
    this.m_sPrefixSegment = "seg";
    this.m_sPrefixCandidateTR = "cand_row";
    this.m_sSelectedPanelID = "selectpanel";
    this.m_sDropdownBtnID = "ddBTN";
}
View.AdvXiaLianView.prototype = 
{

    // Store the current result and construct advanced xialian view in the DOM
    set_result: function(result)
    {
        this.m_rgCurResult = result;
    },
    // Properties
    set_selectedID: function(ID)
    {
        if(ID!=this.m_iSelectedID) 
        {
            this.set_segmentPatternChanged(true);
        }
        else
        {
            this.set_segmentPatternChanged(false);
        }
        this.m_iSelectedID = ID;
    },
    
    get_selectedID: function()
    {
        return this.m_iSelectedID;
    },
    
    set_Xialian: function(xialian)
    {
        this.m_sXialian = xialian;
    },
    
    get_Shanglian: function()
    {
        return this.m_sShanglian;
    },
    
    set_display: function (isDisplayed)
    {
        var dis = isDisplayed ? "" : "none";
        this.get_element().style.display = dis;
    },
    
    get_segmentPatternChanged: function()
    {
        return this.m_fSegmentPatternChanged;
    },
    
    set_segmentPatternChanged: function(flag)
    {
        this.m_fSegmentPatternChanged = flag;
    },
    
    /// <summary>
	/// This method is to clear content of <div id="divAdvancedView">.
	/// </summary>
    /// <accessibility>public</accessibility>
    clear: function()
    {
        if(this.m_divcandidateView.childNodes[0]!=null)		                                       
            this.m_divcandidateView.removeChild(this.m_divcandidateView.childNodes[0]);
        var length = this.m_divSelectedPanelView.childNodes.length;
        for(var i = 0; i < length; i++)
        {
            this.m_divSelectedPanelView.removeChild(this.m_divSelectedPanelView.childNodes[0]);
        }
       this.m_rgCurResult=null;
    },

    /// <summary>
	/// This method is to set the style of display and set the position of the selected panel.
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="isDisplayed">a boolean. If true, the panel is display.</param>
    set_selectpanel_display: function (isDisplayed)
    {
        var dis = isDisplayed ? "" : "none";
        //this.get_element().childNodes[0].childNodes[1].style.display = dis;
        //in firefox childNodes[i] is a textnode which can not get its childNodes again.
        this.m_divSelectedPanelView.style.display = dis;
        if(isDisplayed)
        {
		    var divselectpanel = $get( this.m_sSelectedPanelID );
		    divselectpanel.style.top = parseInt(this.getTop(this.m_divShanglianAdvancedWrapper)) + 40 + "px";
		    divselectpanel.style.left = this.getLeft(this.m_divShanglianAdvancedWrapper) + "px";
        }
    },
    
    /// <summary>
	/// This method is to get the y offset of the element.
	/// </summary>
    /// <accessibility>private</accessibility>
	/// <param name="e">event object</param>
	/// <return value>the y offset of the element</return value>
    getTop: function(e)
    { 
        var offset=e.offsetTop; 
        if(e.offsetParent!=null) offset+=this.getTop(e.offsetParent); 
        return offset; 
    } ,

    /// <summary>
	/// This method is to get the x offset of the element.
	/// </summary>
    /// <accessibility>private</accessibility>
	/// <param name="e">event object</param>
	/// <return value>the x offset of the element</return value>
    getLeft: function(e)
    { 
        var offset=e.offsetLeft; 
        if(e.offsetParent!=null) offset+=this.getLeft(e.offsetParent); 
        return offset; 
    },
    
    //event handler for candidate's click event
    add_click: function(handler) 
    {
        this.get_events().addHandler("click", handler);
    },
    
    remove_click: function(handler) 
    {
        this.get_events().removeHandler("click", handler);
    },
    //event handler for candidate's mouse over event
    add_hover: function(handler) 
    {
        this.get_events().addHandler("hover", handler);
    },
    
    remove_hover: function(handler) 
    {
        this.get_events().removeHandler("hover", handler);
    },
    //event handler for candidate's mouse out event
    add_unhover: function(handler) 
    {
        this.get_events().addHandler("unhover", handler);
    },
    
    remove_unhover: function(handler) 
    {
        this.get_events().removeHandler("unhover", handler);
    },
    //event handler for select panel's click event   
    add_spclick: function(handler) 
    {
        this.get_events().addHandler("SPclick", handler);
    },
    
    remove_spclick: function(handler) 
    {
        this.get_events().removeHandler("SPclick", handler);
    },
    //event handler for select panel's mouse over event   
    add_sphover: function(handler) 
    {
        this.get_events().addHandler("SPhover", handler);
    },
    
    remove_sphover: function(handler) 
    {
        this.get_events().removeHandler("SPhover", handler);
    },
    //event handler for select panel's mouse out event   
    add_spunhover: function(handler) 
    {
        this.get_events().addHandler("SPunhover", handler);
    },
    
    remove_spunhover: function(handler) 
    {
        this.get_events().removeHandler("SPunhover", handler);
    },
    //event handler for title of select panel's click event   
    add_titleclick: function(handler) 
    {
        this.get_events().addHandler("Titleclick", handler);
    },
    
    remove_titleclick: function(handler) 
    {
        this.get_events().removeHandler("Titleclick", handler);
    },
    
    add_clearclick: function(handler) 
    {
        this.get_events().addHandler("Clearclick", handler);
    },
    
    remove_clearclick: function(handler) 
    {
        this.get_events().removeHandler("Clearclick", handler);
    },
    //event handler for xialian input box mouse over event
    add_XLmouseover: function(handler) 
    {
        this.get_events().addHandler("XLmouseover", handler);
    },
    
    remove_XLmouseover: function(handler) 
    {
        this.get_events().removeHandler("XLmouseover", handler);
    },    
    //event handler for xialian input box's key down event
    add_XLkeydown: function(handler) 
    {
        this.get_events().addHandler("XLkeydown", handler);
    },
    
    remove_XLkeydown: function(handler) 
    {
        this.get_events().removeHandler("XLkeydown", handler);
    },
    //event handler for xialian input box's key up event
    add_XLkeyup: function(handler) 
    {
        this.get_events().addHandler("XLkeyup", handler);
    },
    
    remove_XLkeyup: function(handler) 
    {
        this.get_events().removeHandler("XLkeyup", handler);
    },
    //event handler for xialian input box's change event
    add_XLchange: function(handler) 
    {
        this.get_events().addHandler("XLchange", handler);
    },
    
    remove_XLchange: function(handler) 
    {
        this.get_events().removeHandler("XLchange", handler);
    },
    //event handler for xialian input box's focus event
    add_XLfocus: function(handler) 
    {
        this.get_events().addHandler("XLfocus", handler);
    },
    
    remove_XLfocus: function(handler)
    {
        this.get_events().removeHandler("XLfocus", handler);
    },
    //event handler for xialian input box's blur event
    add_XLblur: function(handler) 
    {
        this.get_events().addHandler("XLblur", handler);
    },
    
    remove_XLblur: function(handler) 
    {
        this.get_events().removeHandler("XLblur", handler);
    },
    //event handler for xialian inputbox's click event
    add_XLclick: function(handler) 
    {
        this.get_events().addHandler("XLclick", handler);
    },
    
    remove_XLclick: function(handler) 
    {
        this.get_events().removeHandler("XLclick", handler);
    },
    //event handler for shanglian inputbox's mouse over event
    add_SLmouseover: function(handler) 
    {
        this.get_events().addHandler("SLmouseover", handler);
    },
    
    remove_SLmouseover: function(handler) 
    {
        this.get_events().removeHandler("SLmouseover", handler);
    },
    //event handler for shanglian inputbox's keydown event
    add_SLkeydown: function(handler) 
    {
        this.get_events().addHandler("SLkeydown", handler);
    },
    
    remove_SLkeydown: function(handler) 
    {
        this.get_events().removeHandler("SLkeydown", handler);
    },
    //event handler for shanglian inputbox's keyup event
    add_SLkeyup: function(handler) 
    {
        this.get_events().addHandler("SLkeyup", handler);
    },
    
    remove_SLkeyup: function(handler) 
    {
        this.get_events().removeHandler("SLkeyup", handler);
    },
    //event handler for shanglian inputbox's textchange event
    add_SLchange: function(handler) 
    {
        this.get_events().addHandler("SLchange", handler);
    },
    
    remove_SLchange: function(handler) 
    {
        this.get_events().removeHandler("SLchange", handler);
    },
    //event handler for shanglian inputbox's focus event
    add_SLfocus: function(handler) 
    {
        this.get_events().addHandler("SLfocus", handler);
    },
    
    remove_SLfocus: function(handler) 
    {
        this.get_events().removeHandler("SLfocus", handler);
    },
    //event handler for shanglian inputbox's blur event
    add_SLblur: function(handler) 
    {
        this.get_events().addHandler("SLblur", handler);
    },
    
    remove_SLblur: function(handler) 
    {
        this.get_events().removeHandler("SLblur", handler);
    },
    //event handler for shanglian inputbox's click event
    add_SLclick: function(handler) 
    {
        this.get_events().addHandler("SLclick", handler);
    },
    
    remove_SLclick: function(handler) 
    {
        this.get_events().removeHandler("SLclick", handler);
    },

    // Release resources before control is disposed.
    dispose: function() 
    {

        // element is <div id="divAdvView" />
        var element = this.get_element();
        
        //if element is null, then return
        if(element === undefined) 
            return ;
        //if selected panel or candidate panel has not child, return.   
        // The firstChild refers to <table id="divSelectionView">...</table> 
        // The firstChild refers to <table id="divCandView">...</table>
        if(element.firstChild.firstChild==null || element.lastChild.firstChild==null) 
        {
            return;
        }
        // CR0: FF does not understand .firstChild.firstChild    
        if($get(this._CONST_CAND_TBODY)==null) return;
        var rgRows = $get(this._CONST_CAND_TBODY).childNodes;
        var iLength = rgRows.length;

        //remove three kinds of event "click","mouseover" and "mouseout" on each candidate view <td>
        if (this.m_dgClickCandidateDelegate) {
            
            for(var i=0;i<iLength;i++)
            {
                for(var j=0;j<rgRows[i].childNodes.length;j++)
                {
                    if(rgRows[i].childNodes[j].id!="")
                    {
                        Sys.UI.DomEvent.removeHandler(rgRows[i].childNodes[j], "click", this.m_dgClickCandidateDelegate);
                    }
                }
            }
            delete this.m_dgClickCandidateDelegate;
        }

        if (this.m_dgHoverCandidateDelegate) 
        {
            for(var i=0;i<iLength;i++)
            {
                for(var j=0;j<rgRows[i].childNodes.length;j++)
                {
                    if(rgRows[i].childNodes[j].id!="")
                    {
                        Sys.UI.DomEvent.removeHandler(rgRows[i].childNodes[j], "mouseover", this.m_dgHoverCandidateDelegate);
                    }
                }
            }
            delete this.m_dgHoverCandidateDelegate;
        }

        if (this.m_dgUnhoverCandidateDelegate) 
        {
            for(var i=0;i<iLength;i++)
            {
                for(var j=0;j<rgRows[i].childNodes.length;j++)
                {
                    if(rgRows[i].childNodes[j].id!="")
                    {    
                        Sys.UI.DomEvent.removeHandler(rgRows[i].childNodes[j], "mouseout", this.m_dgUnhoverCandidateDelegate);
                    }
                }
            }
            delete this.m_dgUnhoverCandidateDelegate;
        }
        
        //remove three kinds of event "click","mouseover" and "mouseout" on each select panel

        var divselectpanel = $get( this.m_sSelectedPanelID );
        for( i = 0; i<divselectpanel.childNodes.length; i++)
        {
            Sys.UI.DomEvent.removeHandler(divselectpanel.childNodes[i], "click", this.m_dgClickSelectedPanelDelegate);
            Sys.UI.DomEvent.removeHandler(divselectpanel.childNodes[i], "mouseover", this.m_dgHoverSelectedPanelDelegate);
            Sys.UI.DomEvent.removeHandler(divselectpanel.childNodes[i], "mouseout", this.m_dgUnhoverSelectedPanelDelegate);
        }
        delete this.m_dgClickSelectedPanelDelegate;
        delete this.m_dgHoverSelectedPanelDelegate;
        delete this.m_dgUnhoverSelectedPanelDelegate;
        
        //remove event handler from shanglian and xialian input box
        for( i=0; i<this.m_sShanglian.length; i++ )
        {
	        var insutSL_id = this.m_sPrefixSegment + gConst_ShangLian + i;
	        var shanglianinput = $get(insutSL_id);
	        if(shanglianinput!=null)
	        {
                Sys.UI.DomEvent.removeHandler(shanglianinput, "mouseover", this.m_dgSLMouseOverDelegate);
                Sys.UI.DomEvent.removeHandler(shanglianinput, "keydown", this.m_dgSLKeyDownDelegate);
                Sys.UI.DomEvent.removeHandler(shanglianinput, "keyup", this.m_dgSLKeyUpDelegate);
                Sys.UI.DomEvent.removeHandler(shanglianinput, "change", this.m_dgSLChangeDelegate);
                Sys.UI.DomEvent.removeHandler(shanglianinput, "focus", this.m_dgSLFocusDelegate);
                Sys.UI.DomEvent.removeHandler(shanglianinput, "blur", this.m_dgSLBlurDelegate);
            }
            var insutXL_id = this.m_sPrefixSegment + gConst_XiaLian + i;
            var xialianinput = $get(insutXL_id);
	        if(xialianinput!=null)
	        {
                Sys.UI.DomEvent.removeHandler(xialianinput, "mouseover", this.m_dgXLMouseOverDelegate);
                Sys.UI.DomEvent.removeHandler(xialianinput, "keydown", this.m_dgXLKeyDownDelegate);
                Sys.UI.DomEvent.removeHandler(xialianinput, "keyup", this.m_dgXLKeyUpDelegate);
                Sys.UI.DomEvent.removeHandler(xialianinput, "change", this.m_dgXLChangeDelegate);
                Sys.UI.DomEvent.removeHandler(xialianinput, "focus", this.m_dgXLFocusDelegate);
                Sys.UI.DomEvent.removeHandler(xialianinput, "blur", this.m_dgXLBlurDelegate);
            }
        }
        delete this.m_dgXLMouseOverDelegate;
        delete this.m_dgXLKeyDownDelegate;
        delete this.m_dgXLKeyUpDelegate;
        delete this.m_dgXLChangeDelegate;
        delete this.m_dgXLFocusDelegate;
        delete this.m_dgXLBlurDelegate;
        delete this.m_dgSLMouseOverDelegate;
        delete this.m_dgSLKeyDownDelegate;
        delete this.m_dgSLKeyUpDelegate;
        delete this.m_dgSLChangeDelegate;
        delete this.m_dgSLFocusDelegate;
        delete this.m_dgSLBlurDelegate;
        
        View.AdvXiaLianView.callBaseMethod(this, "dispose");
    },

    initialize: function() {
        
        if (this.m_dgClickCandidateDelegate === null) 
        {
            this.m_dgClickCandidateDelegate = Function.createDelegate(this, this._clickHandler);
        }

        if (this.m_dgHoverCandidateDelegate === null) 
        {
            this.m_dgHoverCandidateDelegate = Function.createDelegate(this, this._hoverHandler);
        }

        if (this.m_dgUnhoverCandidateDelegate === null) 
        {
            this.m_dgUnhoverCandidateDelegate = Function.createDelegate(this, this._unhoverHandler);
        }
        
        if (this.m_dgClickSelectedPanelDelegate === null) 
        {
            this.m_dgClickSelectedPanelDelegate = Function.createDelegate(this, this._clickSPHandler);
        }

        if (this.m_dgHoverSelectedPanelDelegate === null) 
        {
            this.m_dgHoverSelectedPanelDelegate = Function.createDelegate(this, this._hoverSPHandler);
        }

        if (this.m_dgUnhoverSelectedPanelDelegate === null) 
        {
            this.m_dgUnhoverSelectedPanelDelegate = Function.createDelegate(this, this._unhoverSPHandler);
        }
        
        if (this.m_dgClickSelectedPanelTitleDelegate === null) 
        {
            this.m_dgClickSelectedPanelTitleDelegate = Function.createDelegate(this, this._clickTitleHandler);
        }
        
        if (this.m_dgXLMouseOverDelegate === null) 
        {
            this.m_dgXLMouseOverDelegate = Function.createDelegate(this, this._XLmouseoverHandler);
        }

        
        if (this.m_dgXLKeyDownDelegate === null) 
        {
            this.m_dgXLKeyDownDelegate = Function.createDelegate(this, this._XLkeydownHandler);
        }

        if (this.m_dgXLKeyUpDelegate === null) 
        {
            this.m_dgXLKeyUpDelegate = Function.createDelegate(this, this._XLkeyupHandler);
        }
        
        if (this.m_dgXLChangeDelegate === null) {
            this.m_dgXLChangeDelegate = Function.createDelegate(this, this._XLchangeHandler);
        }

        if (this.m_dgXLFocusDelegate === null) 
        {
            this.m_dgXLFocusDelegate = Function.createDelegate(this, this._XLfocusHandler);
        }
        
        if (this.m_dgXLBlurDelegate === null) 
        {
            this.m_dgXLBlurDelegate = Function.createDelegate(this, this._XLblurHandler);
        }
        
        if (this.m_dgXLClickDelegate === null) 
        {
            this.m_dgXLClickDelegate = Function.createDelegate(this, this._XLclickHandler);
        }
        
        if (this.m_dgSLMouseOverDelegate === null) 
        {
            this.m_dgSLMouseOverDelegate = Function.createDelegate(this, this._SLmouseoverHandler);
        }

        
        if (this.m_dgSLKeyDownDelegate === null) 
        {
            this.m_dgSLKeyDownDelegate = Function.createDelegate(this, this._SLkeydownHandler);
        }

        if (this.m_dgSLKeyUpDelegate === null) 
        {
            this.m_dgSLKeyUpDelegate = Function.createDelegate(this, this._SLkeyupHandler);
        }
        
        if (this.m_dgSLChangeDelegate === null) {
            this.m_dgSLChangeDelegate = Function.createDelegate(this, this._SLchangeHandler);
        }

        if (this.m_dgSLFocusDelegate === null) 
        {
            this.m_dgSLFocusDelegate = Function.createDelegate(this, this._SLfocusHandler);
        }
        
        if (this.m_dgSLBlurDelegate === null) 
        {
            this.m_dgSLBlurDelegate = Function.createDelegate(this, this._SLblurHandler);
        }
        if (this.m_dgSLClickDelegate === null) 
        {
            this.m_dgSLClickDelegate = Function.createDelegate(this, this._SLclickHandler);
        }

        View.AdvXiaLianView.callBaseMethod(this, "initialize");

    },
    
    // These internal defined handlers are used to 
    // create corresponding delegates. In this pattern, we
    // can decouple the control initialization logic from client
    // custom event handler assignment.
    _clickHandler: function(event) 
    {
        var h = this.get_events().getHandler("click");
        var sender = this._getSender(event);
        if (h) h(sender, Sys.EventArgs.Empty);
        if(sender.tagName.indexOf("INPUT")!=-1)
            sender = sender.parentNode;

        // Extract the position information from td"s id. E.g. <td id="p1c4r2" ...>...</td>
	    //means the first segment part, the fourth cell in the second row
        var beginindex=sender.id.slice(3,4);
        var sb_CSS = new Sys.StringBuilder();
        sb_CSS.append(this.m_sXialian.slice(0,beginindex));
	    //process every word in a TD
        for(var j=0;j<sender.childNodes.length;j++)
        {
            sb_CSS.append(sender.childNodes[j].value);
            beginindex++;
        }
        sb_CSS.append(this.m_sXialian.slice(parseInt(beginindex)));
        this.m_sXialian = sb_CSS.toString();
    },
    
    _hoverHandler: function(event) 
    {
        var h = this.get_events().getHandler("hover");
        var sender = this._getSender(event);
        if (h) h(sender, Sys.EventArgs.Empty);
    },
    
    _unhoverHandler: function(event) 
    {
        var h = this.get_events().getHandler("unhover");
        var sender = this._getSender(event);
        if (h) h(sender, Sys.EventArgs.Empty);
    },
    
    _clickSPHandler: function(event) 
    {
        var h = this.get_events().getHandler("SPclick");
        var sender = this._getSender(event);
        if (h) h(sender, event );
        //extract the index from a string like "sp1"
        //the third char is the number, so use slice(2)
        this.set_selectedID(sender.id.slice(2));
	    //if the segment pattern changed,
	    //render the candidate view again.
        if(this.get_segmentPatternChanged())
        {
            this.renderAdvView();
        }
    },
    
    _hoverSPHandler: function(event) 
    {
        var h = this.get_events().getHandler("SPhover");
        var sender = this._getSender(event);
        if (h) h(sender, Sys.EventArgs.Empty);
    },
    
    _unhoverSPHandler: function(event) 
    {
        var h = this.get_events().getHandler("SPunhover");
        var sender = this._getSender(event);
        if (h) h(sender, Sys.EventArgs.Empty);
    },
    
    _clickTitleHandler: function(event) 
    {
        var h = this.get_events().getHandler("Titleclick");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLmouseoverHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLmouseover");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLkeydownHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLkeydown");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLkeyupHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLkeyup");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLchangeHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLchange");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLfocusHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLfocus");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLblurHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLblur");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _XLclickHandler: function(event) 
    {
        var h = this.get_events().getHandler("XLclick");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLmouseoverHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLmouseover");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLkeydownHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLkeydown");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLkeyupHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLkeyup");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLchangeHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLchange");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLfocusHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLfocus");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLblurHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLblur");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    _SLclickHandler: function(event) 
    {
        var h = this.get_events().getHandler("SLclick");
        var sender = this._getSender(event);
        if (h) h(sender, event);
    },
    
    /// <summary>
	/// This method is to get the element who invoked current evnet.
	/// </summary>
    /// <accessibility>private</accessibility>
	/// <param name="evt">event object</param>
	/// <return value>If success, it will return DOM element</return value>
    _getSender: function(e)
    {
        var target = e.target;              // DOM standard event model
        if (!target)
        {
            target = e.srcElement;          // IE event model
        }
        
        return target;
    },
    
    /// <summary>
	/// This method is to get one shanglian/xialian word according to candidate id  .
	/// </summary>
    /// <accessibility>public</accessibility> 
    /// <param name="candidateID">ID of the candidate</param>
    /// <param name="lian">shanglian or xialian</param>
    /// <return>one shanglian/xialian word according to candidate id</return>
    getADVSelectedByID: function(candidateID, lian){
        var selectedCandidate;
	    if(document.all)
	    {
	        selectedCandidate = $get(this.m_sPrefixSegment + lian + candidateID ).innerText;
	    }
	    else
	    {
	        selectedCandidate = $get(this.m_sPrefixSegment + lian + candidateID ).textContent;
	    }
	    return selectedCandidate;
    },
    
    /// <summary>
	/// This method is to set one shanglian/xialian word according to candidate id .
	/// </summary>
    /// <accessibility>public</accessibility> 
    /// <param name="candidateID">ID of the candidate</param>
    /// <param name="lian">shanglian or xialian</param>
    /// <param name="content">content to set</param>
    setADVSelectedByID: function(candidateID, lian, content)
    {
        if($get(this.m_sPrefixSegment + lian + candidateID )==null)
        {
            return;
        }
	    if(document.all)
	    {
	        $get(this.m_sPrefixSegment + lian + candidateID ).value = content;
	    }
	    else
	    {
	        $get(this.m_sPrefixSegment + lian + candidateID ).value = content;
	    }
    },
    
    /// <summary>
	/// This method is to get the max length of the candidates for some segmentation pattern.
	/// </summary>
    /// <accessibility>private</accessibility> 
    /// <param name="rgResult">A candidate result array</param>
    /// <return>the max length of the candidates for some segmentation pattern</return>
    GetMaxLength :function(rgResult)
    {
        var sSegPattern = rgResult.SegmentPattern;
        sSegPattern = sSegPattern.substring( 0, sSegPattern.length - 1 );
	    var rgPattern = sSegPattern.split( "/" );  
	    var max=0; 
	    var j=0;// j is the current index of word in the segment, not including "/"
    	
	    for (var i=0; i<sSegPattern.length;)// i is the index of segmentation pattern, including "/", such as 海阔/凭/鱼跃
	    {
	        if ( sSegPattern.charAt( i ) != "/" )
		    {
	            var currentWordCandidateCount = rgResult.WordCandidatesInColumnOrder[j].length;
	            if(currentWordCandidateCount > max)
	            {
	                max = currentWordCandidateCount;
	            }
	            i += rgPattern[ j ].length;
	            j++;
	        }
	        else i++;
	    }
	    return max;
    },
    
    /// <summary>
	/// This method is to set the position of the selected panel.
	/// </summary>
    /// <accessibility>private</accessibility> 
    /// <param name="iLeft">left position of the select panel</param>
	/// <param name="iTop">top position of the select panel</param>  
    set_selectpanel_position: function(iLeft,iTop)
    {
        this.m_divSelectpanelContent.style.left = iLeft;
        this.m_divSelectpanelContent.style.top = iTop;
    },
    
    /// <summary>
	/// This method is to render both selected panel and candidate view.
	/// </summary>
    /// <accessibility>public</accessibility>
    renderAdvView: function()
    {
        this.constructAdvXiaLianView();       
        this.generateAdvancedSelected();
        this.constructSegmentView();
    },
    
    /// <summary>
	/// This method is to construct candidate view.
	/// </summary>
    /// <accessibility>private</accessibility>
    constructAdvXiaLianView: function()
    {
        //The result should not be null
        if(this.m_rgCurResult == null) 
        {
            return;
        }
        //get the result according to selected ID
        var rgResult = this.m_rgCurResult.XialianSystemGeneratedSets[this.m_iSelectedID];       
        if(rgResult)
        {
            //sSegPattern is like "海阔/凭/鱼跃/"
            var sSegPattern = rgResult.SegmentPattern;
            //after getting substring, sSegPattern is like "海阔/凭/鱼跃"
		    sSegPattern = sSegPattern.substring( 0, sSegPattern.length - 1 );
		    //rgPattern	stores some element such as "海阔","凭","鱼跃".
		    var rgPattern = sSegPattern.split( "/" );
            //r is the current row
		    var r=0;
		    //j is the current index of word in the segment, not including "/"
		    var j=0;
		    // i is the index of segmentation pattern, including "/", such as 海阔/凭/鱼跃
		    var i=0;
		    // jPos stores the position of word j in the segment, not including "/"
		    var jPos ;
		    //iMax is the max row of the candidate matrix.
		    var iMax = this.GetMaxLength(rgResult); 
		    
		    var table = document.createElement("table");
            table.id = this.m_sXialianTableID;
            table.style.cssText = "WIDTH: 290px;";

//            if(!document.all)
//            {
//                table.style.left = "0px";
//                table.style.position = "relative";
//                table.style.top = "-20px";
//            }
            var tbd = document.createElement("TBODY");
            tbd.id = this._CONST_CAND_TBODY;
	        table.appendChild(tbd);
            //Width of the candidate table is 300px.
            //so, each of the cell's width is 300px divided by word count of shanglian 
	        var tdwidth = parseInt(300/this.m_sShanglian.length);
	        
		    //iMax is the iMax length row in Adv_XiaLian_table
		    for(var r=0 ; r<iMax ;r++)
		    {
		        var tr = document.createElement("tr");
		        tr.id = this.m_sPrefixCandidateTR + r;
		        var sb_CSS_1 = new Sys.StringBuilder();
                sb_CSS_1.append("WIDTH: 290px;height:");
                sb_CSS_1.append(gConst_FontSize);
                sb_CSS_1.append("px;");
                tr.style.cssText = sb_CSS_1.toString();

		        jPos=0;
		        for(var j=0;j<rgPattern.length;j++)
		        {
                    //the size of a candidate list is less than the Max, show the candidate 
		            if( r<rgResult.WordCandidatesInColumnOrder[j].length )
		            {
		                // Here "rgCand" refer to a word that may constains several chars.
		                // E.g.: 海/阔/凭/鱼跃/
		                // "海", "阔", "凭" and "鱼跃" are all rgCand(s)
		                var rgCand = rgResult.WordCandidatesInColumnOrder[j][r];
		                var td = document.createElement("td");
		                // <td id='p1c4r2' ...>...</td>
	                    //means the first segment part, the fourth cell in the second row
		                td.id = "p"+j+"c"+jPos+"r"+r;
			            //the width of the TD set to candidate word count*one TD's length.
                        var sb_CSS_2 = new Sys.StringBuilder();
                        sb_CSS_2.append("WIDTH: ");
                        sb_CSS_2.append(parseInt(tdwidth * rgCand.length));
                        sb_CSS_2.append("px;text-align: center;");
                        td.style.cssText = sb_CSS_2.toString();
                        //create one textbox for each word
                        for (k = 0; k<rgCand.length; k++ )
                        {
                            var txtadv = document.createElement("input");
                            txtadv.type = "text";
                            txtadv.value = rgCand.charAt(k);
                            txtadv.id = this.m_sPrefixAdvance + parseInt(jPos + k);
                            txtadv.maxLength = 1;
                            txtadv.className = "advUncheck";
                            txtadv.readOnly = true;
                            td.appendChild(txtadv); 
                         }
                        //attach event
                        if (this.m_dgClickCandidateDelegate === null) {
                            this.m_dgClickCandidateDelegate = Function.createDelegate(this, this._clickHandler);
                        }
                        Sys.UI.DomEvent.addHandler(td, "click", this.m_dgClickCandidateDelegate);
                        
                        if (this.m_dgHoverCandidateDelegate === null) {
                            this.m_dgHoverCandidateDelegate = Function.createDelegate(this, this._hoverHandler);
                        }
                        Sys.UI.DomEvent.addHandler(td, "mouseover", this.m_dgHoverCandidateDelegate);
                        
                        if (this.m_dgUnhoverCandidateDelegate === null) {
                            this.m_dgUnhoverCandidateDelegate = Function.createDelegate(this, this._unhoverHandler);
                        }
                        Sys.UI.DomEvent.addHandler(td, "mouseout", this.m_dgUnhoverCandidateDelegate);
		                //if the word is not the last one in the sentence,
		                //add the right border of the textbox
		                if(j<rgPattern.length-1)
		                {
		                    td.style.borderRightWidth = "1px";
		                    td.style.borderRightStyle = "solid";
		                    td.style.borderRightColor = "#aaaaaa";
		                }
		                tr.appendChild(td);

		                jPos += rgCand.length;
		            }
		            else//use a blank cell to fill 
		            {
		               var rgCand = rgResult.WordCandidatesInColumnOrder[j][0];
		               var tdblank = document.createElement("td");
		               tdblank.style.width =  parseInt(tdwidth * rgCand.length) + "px";
                       tdblank.style.height = gConst_FontSize + "px";
		               if(j<rgPattern.length-1)
		               {
		                    tdblank.style.borderRightWidth = "1px";
		                    tdblank.style.borderRightStyle = "solid";
		                    tdblank.style.borderRightColor = "#aaaaaa";
		                }
		               tr.appendChild(tdblank);

		               jPos += rgCand.length;
		            }
		        }
		        tbd.appendChild(tr);
		        //use a space row to seperate two line;
		        var spacerow = document.createElement("tr");
		        spacerow.style.cssText= "WIDTH: 290px;height:3px;";
		        spacerow.colspan = rgPattern.length;
		        tbd.appendChild(spacerow);
		    }
            //delete the old content, if necessary, and append the table to the outer DIV
            if(this.m_divcandidateView.childNodes[0]!=null)
            {		                                       
                this.m_divcandidateView.removeChild(this.m_divcandidateView.childNodes[0]);
            }
            this.m_divcandidateView.appendChild(table);
        }
    },
    
    /// <summary>
	/// This method is to construct segment pattern view.
	/// </summary>
    /// <accessibility>private</accessibility>
    constructSegmentView: function()
    {
        var result = this.m_rgCurResult;
        if(result == null) return;
        if (result.XialianSystemGeneratedSets != null)
	    {
		    var sformattedSegPattern;
   		
    		//create selected area in selection panel and attach click,mouseover and mouse out event
    		var selectpanel = document.createElement("div");
    		selectpanel.border = "1";
    		selectpanel.id = this.m_sSelectedPanelID;
    		selectpanel.className = "selectpanel";
            for ( var i = 0; i < result.XialianSystemGeneratedSets.length; i++ )
		    {
		        //replace all "/" in result with "|"
		        sformattedSegPattern = result.XialianSystemGeneratedSets[ i ].SegmentPattern;
			    sformattedSegPattern = replaceAll( sformattedSegPattern.substring( 0, sformattedSegPattern.length - 1 ), "/", "|" );
                
                //create the head of selection panel and attach click event
		        var tableSL = document.createElement("table");
		        tableSL.id = "ot" + i;
                var sb_CSS_1 = new Sys.StringBuilder();
                sb_CSS_1.append("height: 20");
                sb_CSS_1.append("px;width:293px;");
                tableSL.style.cssText = sb_CSS_1.toString();
                
                var tmpSL = document.createElement("TBODY");
                tableSL.appendChild(tmpSL);
                var rowSL = document.createElement("tr");
                rowSL.id = "or" + i;
                var colSL = document.createElement("td");
                colSL.id = "oc" + i;
                tmpSL.appendChild(rowSL);
                rowSL.appendChild(colSL);
                
                var innertableSL = document.createElement("table");
                
                var sb_CSS_2 = new Sys.StringBuilder();
                sb_CSS_2.append("height: 20");
                sb_CSS_2.append("px;width:293px;");
                innertableSL.style.cssText = sb_CSS_2.toString(); 
                       
                innertableSL.id = "it" + i;
                var innertmpSL = document.createElement("TBODY");
                innertableSL.appendChild(innertmpSL);
                var innerrowSL = document.createElement("tr");
                innerrowSL.id = "ir" + i;
                innertmpSL.appendChild(innerrowSL);
                
		        var innercolSL ;
		        //Width of the candidate table is 300px.
            	//so, each of the cell's width is 300px divided by word count of shanglian 
                var tdwidth = parseInt(300/this.m_sShanglian.length);
                
                var sformattedSegPattern = sformattedSegPattern.split( "|" );
		        //sformattedSegPattern store segments seperated by "|"
                for(var j=0; j<sformattedSegPattern.length; j++)
                {                
                    var inputlength = sformattedSegPattern[j].length;
                    var innercolSL = document.createElement("td");
                    innercolSL.id = "ic" + i;
		            //if the word is not the last one in the sentence,
		            //add the right border of the textbox
                    if( j < sformattedSegPattern.length - 1)
		            {
                        innercolSL.className= "TDwithbar";
                    }
                    innercolSL.style.width = parseInt( tdwidth * inputlength ) + "px";
                    innercolSL.style.fontSize = "18px";
                    innercolSL.style.textAlign = "center";

                    var myNode = document.createTextNode(sformattedSegPattern[j]);
                    
                    innercolSL.appendChild(myNode);
                    innerrowSL.appendChild(innercolSL);
                }
                innerrowSL.appendChild(innercolSL);

                colSL.appendChild(innertableSL); 
                rowSL.appendChild(colSL);                           

                //attach event
                if (this.m_dgClickSelectedPanelDelegate === null) {
                    this.m_dgClickSelectedPanelDelegate = Function.createDelegate(this, this._clickSPHandler);
                }
                Sys.UI.DomEvent.addHandler(tableSL, "click", this.m_dgClickSelectedPanelDelegate);
                
                if (this.m_dgHoverSelectedPanelDelegate === null) {
                    this.m_dgHoverSelectedPanelDelegate = Function.createDelegate(this, this._hoverSPHandler);
                }
                Sys.UI.DomEvent.addHandler(tableSL, "mouseover", this.m_dgHoverSelectedPanelDelegate);
                
                if (this.m_dgUnhoverSelectedPanelDelegate === null) {
                    this.m_dgUnhoverSelectedPanelDelegate = Function.createDelegate(this, this._unhoverSPHandler);
                }
                Sys.UI.DomEvent.addHandler(tableSL, "mouseout", this.m_dgUnhoverSelectedPanelDelegate);
            
                selectpanel.appendChild(tableSL);
                
		    }
		    //in firefox childNodes[i] is a textnode which can not been appended child
            //this.get_element().childNodes[0].appendChild(selectpanel); 
            if(this.m_divSelectedPanelView.firstChild!=null)
            {
                this.m_divSelectedPanelView.removeChild(this.m_divSelectedPanelView.firstChild); 
            }
            this.m_divSelectedPanelView.appendChild(selectpanel);   
	    }
    },
    
    /// <summary>
	/// This method is to construct input of shanglian and xialian .
	/// </summary>
    /// <accessibility>private</accessibility>
    generateAdvancedSelected: function()
    {            
	    var sformattedSegPattern;
	    //m_rgCurResult can not be null
	    //if system generate is null
	    //add a segment pattern which each word is append with a '/'
	    if(this.m_rgCurResult==null || this.m_rgCurResult.XialianSystemGeneratedSets==null) 
	    {
	        var tempSL = new Sys.StringBuilder();
	        for(i = 0; i<this.m_sShanglian.length; i++)
	        {
	            tempSL.append(this.m_sShanglian.charAt(i));
	            tempSL.append("/");
	        }
	        sformattedSegPattern = tempSL.toString();
	        
	    }
	    else
	    {
		    sformattedSegPattern = this.m_rgCurResult.XialianSystemGeneratedSets[ this.m_iSelectedID ].SegmentPattern;
		}
		sformattedSegPattern = replaceAll( sformattedSegPattern.substring( 0, sformattedSegPattern.length - 1 ), "/", "|" );
		    
		//create the head of selection panel and attach click event
		var tableSL = document.createElement("table");
        var sb_CSS_1 = new Sys.StringBuilder();
        sb_CSS_1.append("height: 20");
        sb_CSS_1.append("px;width:292px;");
        tableSL.style.cssText = sb_CSS_1.toString();
        
        var tmpSL = document.createElement("TBODY");
        tableSL.appendChild(tmpSL);
        var rowSL = document.createElement("tr");
        var colSL = document.createElement("td");
        tmpSL.appendChild(rowSL);
        rowSL.appendChild(colSL);
        
        var innertableSL = document.createElement("table");
        var sb_CSS_2 = new Sys.StringBuilder();
        sb_CSS_2.append("height: 20");
        sb_CSS_2.append("px;width:290px;");
        innertableSL.style.cssText = sb_CSS_2.toString(); 
               
        innertableSL.id = "SL_table";
        var innertmpSL = document.createElement("TBODY");
        innertableSL.appendChild(innertmpSL);
        var innerrowSL = document.createElement("tr");
        innertmpSL.appendChild(innerrowSL);
        innerrowSL.id = "SL_input_tr";
        var innercolSL ;
        
		var tableXL = document.createElement("table");
        var sb_CSS_3 = new Sys.StringBuilder();
        sb_CSS_3.append("height: 36");
        sb_CSS_3.append("px;width:292px;");
        tableXL.style.cssText = sb_CSS_3.toString(); 
        var tmpXL = document.createElement("TBODY");
        tableXL.appendChild(tmpXL);
        var rowXL = document.createElement("tr");
        var colXL = document.createElement("td");
        tmpXL.appendChild(rowXL);
        rowXL.appendChild(colXL);
        
        var innertableXL = document.createElement("table");
        var sb_CSS_4 = new Sys.StringBuilder();
        sb_CSS_4.append("height: 20");
        sb_CSS_4.append("px;width:290px;");
        innertableXL.style.cssText = sb_CSS_4.toString(); 
        innertableXL.id = "XL_table";
        var innertmpXL = document.createElement("TBODY");
        innertableXL.appendChild(innertmpXL);
        var innerrowXL = document.createElement("tr");
        innertmpXL.appendChild(innerrowXL);
        innerrowXL.id = "XL_input_tr";
        var innercolXL ;        
        var tdwidth = parseInt(300/this.m_sShanglian.length);
        
        var cellcontent = sformattedSegPattern.split( "|" );
        var jPos = 0 ;
        
        for(var i=0; i<cellcontent.length; i++)
        {
            var inputlength = cellcontent[i].length;
            
            innercolSL = document.createElement("td");
            if( i < cellcontent.length - 1)
                innercolSL.className= "TDwithbar";
            innercolSL.style.width = parseInt( tdwidth * inputlength ) + "px";
            innercolSL.style.textAlign = "center";
            var inputSL;
            
            for(var j=0; j<inputlength; j++)
            {
                inputSL = document.createElement("input");
                inputSL.type = "text";
                var id = parseInt( jPos + j );
                inputSL.id = this.m_sPrefixSegment + gConst_ShangLian + id;
                inputSL.value = this.m_sShanglian.charAt(id).replace(" ","");
                inputSL.maxLength = g_iMaxLength;
                inputSL.className = "transparantInput";
		        //attach event to the cell
                Sys.UI.DomEvent.addHandler(inputSL,"mouseover",this.m_dgSLMouseOverDelegate);
                Sys.UI.DomEvent.addHandler(inputSL,"focus",this.m_dgSLFocusDelegate);
                Sys.UI.DomEvent.addHandler(inputSL,"blur",this.m_dgSLBlurDelegate);
                Sys.UI.DomEvent.addHandler(inputSL,"change",this.m_dgSLChangeDelegate);
                Sys.UI.DomEvent.addHandler(inputSL,"keydown",this.m_dgSLKeyDownDelegate);
                Sys.UI.DomEvent.addHandler(inputSL,"keyup",this.m_dgSLKeyUpDelegate);
                
                innercolSL.appendChild(inputSL); 
            }
            Sys.UI.DomEvent.addHandler(innercolSL,"click",this.m_dgSLClickDelegate);
            innerrowSL.appendChild(innercolSL);
            
            var innercolXL = document.createElement("td");
            if( i < cellcontent.length - 1)
                innercolXL.className= "TDwithbar";
            innercolXL.style.width = parseInt( tdwidth * inputlength ) + "px";
            innercolXL.style.textAlign = "center";
            var inputXL;
            
            for(var j=0; j<inputlength; j++)
            {
                inputXL = document.createElement("input");
                inputXL.type = "text";
                var id = parseInt( jPos + j );
                inputXL.id = this.m_sPrefixSegment + gConst_XiaLian + id;
                inputXL.value = this.m_sXialian.charAt(jPos+j).replace(" ","");//$get( "prev" + gConst_XiaLian+ id).value;
                inputXL.maxLength = g_iMaxLength;
                inputXL.className = "transparantInput";
		        //attach event to the cell
                Sys.UI.DomEvent.addHandler(inputXL,"mouseover",this.m_dgXLMouseOverDelegate);
                Sys.UI.DomEvent.addHandler(inputXL,"focus",this.m_dgXLFocusDelegate);
                Sys.UI.DomEvent.addHandler(inputXL,"blur",this.m_dgXLBlurDelegate);
                Sys.UI.DomEvent.addHandler(inputXL,"change",this.m_dgXLChangeDelegate);
                Sys.UI.DomEvent.addHandler(inputXL,"keydown",this.m_dgXLKeyDownDelegate);
                Sys.UI.DomEvent.addHandler(inputXL,"keyup",this.m_dgXLKeyUpDelegate);
                
                innercolXL.appendChild(inputXL); 
            }
            Sys.UI.DomEvent.addHandler(innercolXL,"click",this.m_dgXLClickDelegate);
            innerrowXL.appendChild(innercolXL);
            
            jPos+=inputlength;
        }
        
        colSL.appendChild(innertableSL); 
        colXL.appendChild(innertableXL); 
        
        if(this.m_divShanglianAdvancedWrapper.childNodes[0]!=null)		                                       
            this.m_divShanglianAdvancedWrapper.removeChild(this.m_divShanglianAdvancedWrapper.childNodes[0]);
        this.m_divShanglianAdvancedWrapper.appendChild(tableSL);
        if(this.m_divXialianAdvancedWrapper.childNodes[0]!=null)		                                       
            this.m_divXialianAdvancedWrapper.removeChild(this.m_divXialianAdvancedWrapper.childNodes[0]);
        this.m_divXialianAdvancedWrapper.appendChild(tableXL); 
    		   
	   
    }

    
}
View.AdvXiaLianView.registerClass("View.AdvXiaLianView", Sys.UI.Control);

View.XiaLianView = function(element) {

    View.XiaLianView.initializeBase(this, [element]);
    this._CONST_divNormalWrapper = "divNormalWrapper";
    this._CONST_divADVWrapper = "divAdvView";
    //Here, we use a encoded format for maintain the Xialian"s current internal state.
    //The encoded string contains whitespace and selected chineses chars in corresponding positions.
    //The whitespace indicates that user has not assigned a chineses char in current position.
    this.m_sXialian_Input_Mask = "            ";
    
//params list of $create 
//    [
//        {name: "type", type: Type},
//        {name: "properties", mayBeNull: true, optional: true},
//        {name: "events", mayBeNull: true, optional: true},
//        {name: "references", mayBeNull: true, optional: true},
//        {name: "element", mayBeNull: true, domElement: true, optional: true}
//    ] 
//here, param events should be set null, because when XiaLianView is created 
//---------------------------------------------------------------------------------
//$create(View.XiaLianView, null, {normal_click: onNormalClick, normal_hover: onNormalMouseOver, normal_unhover: onNormalMouseOut,
//cand_click: onCandidateClick, cand_hover: onNormalMouseOver, cand_unhover: onNormalMouseOut,
//seg_click: onSelectChanged, seg_hover: onSelectHover, seg_unhover: onSelectUnHover,title_click:DropDownSelectPanel},null, $get("XiaLianView"));
//-----------------------------------------------------------------------------------
//those events have been registed.
    $create(View.NormalXiaLianView, null, null ,null, $get(this._CONST_divNormalWrapper));
    $create(View.AdvXiaLianView, null, null, null, $get(this._CONST_divADVWrapper));

    

    this._normal = $find(this._CONST_divNormalWrapper);
    this._adv = $find(this._CONST_divADVWrapper);


}

View.XiaLianView.prototype = 
{
    /// <summary>
	/// This method is exposed for set result for the component.
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="result">candidate array</param>
	/// <param name="userContext">userContext contains shanglian,xialian,hengpi,IsUpdate and some other parameters</param>
    set_result: function (result, userContext){
        //count the length of shanglian 
            var _seg;
            if(null != result.XialianSystemGeneratedSets)
            {
                _seg = result.XialianSystemGeneratedSets[0].SegmentPattern;
            }
            else
            {
                _seg = result.XialianWellKnownSets[0].SegmentPattern;
            }
		    _seg = replaceAll( _seg.substring( 0, _seg.length - 1 ), "/", "" );
            this.set_Shanglian(_seg);
            if( !userContext.getIsUpdate())
            {
                var xialian_encode = this.m_sXialian_Input_Mask.slice(0,_seg.length);
                this.set_Xialian(xialian_encode);
            }
            else
            {
                this.set_Xialian(replaceAll(userContext.getXialian(), "0", " " ));
            }
            //set result for normal view and candidate view
            this._normal.set_result(result);
            if(null != result.XialianSystemGeneratedSets)
            {
		        //set select ID to 0 manually.
		        //For example, user click a candidate in normal view, and its corresponding segment pattern is 1(the second pattern).
		        //if don"t set the select id to 0, when he goes back to step 0 and regenerate a new xialian
		        //and the new result only has one segment pattern, it will occurs errors.
		        this._adv.set_selectedID(0);
                
                this._adv.set_result(result);
                //after setting result, make normal view display defaultly.
                this._adv.renderAdvView();
                if(this._adv.get_element().style.display==gConst_display_none)
                    this.set_Normal(true);
                else
                    this.set_Normal(false);        
            }
    },

    /// <summary>
	/// This method is exposed for constructing shanglian and xialian input box.
	/// </summary>
    /// <accessibility>public</accessibility>
	/// <param name="shanglian">shanglian text</param>
    constructInput: function(shanglian){
        this.set_Shanglian(shanglian);
        this._normal.GenerateNormalSelected();
        this._adv.generateAdvancedSelected();
    },
        
    /// <summary>
	/// This method is to clear UI and internal state of xialian control.
	/// </summary>
    /// <accessibility>public</accessibility>
    clear: function() {

        this.set_Xialian("");
        this._normal.clear();
        this._adv.clear();

    },
    // Properties
    set_Xialian: function (xialian){
        this._normal.set_Xialian(xialian);
        this._adv.set_Xialian(xialian);
    },
    
    set_Shanglian: function (shanglian){
        this._normal.m_sShanglian = shanglian;
        this._adv.m_sShanglian = shanglian;
    },
    
    //set display of the whole xialian view, including normal view and advanced view
    set_display: function (isDisplayed){
        var dis = isDisplayed ? "" : "none";
        this.get_element().style.display = dis;
        this.set_btn_visible (isDisplayed);
    },
    //set display of either normal view or advanced view
    set_Normal: function(Normal)
    {
        if(Normal)
        {
            this._normal.set_display(true);
            this._adv.set_display(false);
        }
        else
        {
            this._normal.set_display(false);
            
            this._adv.set_display(true);
        }
    },
    
    //set the adv button visible.
    set_btn_visible: function (isVisible){
        var vis = isVisible ? "visible" : "hidden";
        
        $get(gConst_btn_showAdv).style.visibility = vis;
    },
    //event handler
    add_normal_click: function(handler) {
        this._normal.add_click(handler);
    },
    remove_normal_click: function(handler) {
        this._normal.remove_click(handler);
    },
    add_normal_hover: function(handler) {
        this._normal.add_hover(handler);
    },
    remove_normal_hover: function(handler) {
        this._normal.remove_hover(handler);
    },
    add_normal_unhover: function(handler) {
        this._normal.add_unhover(handler);
    },
    remove_normal_unhover: function(handler) {
        this._normal.remove_unhover(handler);
    },
    add_normal_XLmouseover: function(handler) {
        this._normal.add_XLmouseover(handler);
    },
    remove_normal_XLmouseover: function(handler) {
        this._normal.remove_XLmouseover(handler);
    },
    add_normal_XLkeydown: function(handler) {
        this._normal.add_XLkeydown(handler);
    },
    remove_normal_XLkeydown: function(handler) {
        this._normal.remove_XLkeydown(handler);
    },
    add_normal_XLkeyup: function(handler) {
        this._normal.add_XLkeyup(handler);
    },
    remove_normal_XLkeyup: function(handler) {
        this._normal.remove_XLkeyup(handler);
    },
    add_normal_XLchange: function(handler) {
        this._normal.add_XLchange(handler);
    },
    remove_normal_XLchange: function(handler) {
        this._normal.remove_XLchange(handler);
    },
    add_normal_XLfocus: function(handler) {
        this._normal.add_XLfocus(handler);
    },
    remove_normal_XLfocus: function(handler) {
        this._normal.remove_XLfocus(handler);
    },
    add_normal_XLblur: function(handler) {
        this._normal.add_XLblur(handler);
    },
    remove_normal_XLblur: function(handler) {
        this._normal.remove_XLblur(handler);
    },
    add_normal_XLclick: function(handler) {
        this._normal.add_XLclick(handler);
    },
    remove_normal_XLclick: function(handler) {
        this._normal.remove_XLclick(handler);
    },
    add_normal_SLmouseover: function(handler) {
        this._normal.add_SLmouseover(handler);
    },
    remove_normal_SLmouseover: function(handler) {
        this._normal.remove_SLmouseover(handler);
    },
    add_normal_SLkeydown: function(handler) {
        this._normal.add_SLkeydown(handler);
    },
    remove_normal_SLkeydown: function(handler) {
        this._normal.remove_SLkeydown(handler);
    },
    add_normal_SLkeyup: function(handler) {
        this._normal.add_SLkeyup(handler);
    },
    remove_normal_SLkeyup: function(handler) {
        this._normal.remove_SLkeyup(handler);
    },
    add_normal_SLchange: function(handler) {
        this._normal.add_SLchange(handler);
    },
    remove_normal_SLchange: function(handler) {
        this._normal.remove_SLchange(handler);
    },
    add_normal_SLfocus: function(handler) {
        this._normal.add_SLfocus(handler);
    },
    remove_normal_SLfocus: function(handler) {
        this._normal.remove_SLfocus(handler);
    },
    add_normal_SLblur: function(handler) {
        this._normal.add_SLblur(handler);
    },
    remove_normal_SLblur: function(handler) {
        this._normal.remove_SLblur(handler);
    },
    add_normal_SLclick: function(handler) {
        this._normal.add_SLclick(handler);
    },
    remove_normal_SLclick: function(handler) {
        this._normal.remove_SLclick(handler);
    },
    
    add_adv_XLmouseover: function(handler) {
        this._adv.add_XLmouseover(handler);
    },
    remove_adv_XLmouseover: function(handler) {
        this._adv.remove_XLmouseover(handler);
    },
    add_adv_XLkeydown: function(handler) {
        this._adv.add_XLkeydown(handler);
    },
    remove_adv_XLkeydown: function(handler) {
        this._adv.remove_XLkeydown(handler);
    },
    add_adv_XLkeyup: function(handler) {
        this._adv.add_XLkeyup(handler);
    },
    remove_adv_XLkeyup: function(handler) {
        this._adv.remove_XLkeyup(handler);
    },
    add_adv_XLchange: function(handler) {
        this._adv.add_XLchange(handler);
    },
    remove_adv_XLchange: function(handler) {
        this._adv.remove_XLchange(handler);
    },
    add_adv_XLfocus: function(handler) {
        this._adv.add_XLfocus(handler);
    },
    remove_adv_XLfocus: function(handler) {
        this._adv.remove_XLfocus(handler);
    },
    add_adv_XLblur: function(handler) {
        this._adv.add_XLblur(handler);
    },
    remove_adv_XLblur: function(handler) {
        this._adv.remove_XLblur(handler);
    },
    add_adv_XLclick: function(handler) {
        this._adv.add_XLclick(handler);
    },
    remove_adv_XLclick: function(handler) {
        this._adv.remove_XLclick(handler);
    },
    add_adv_SLmouseover: function(handler) {
        this._adv.add_SLmouseover(handler);
    },
    remove_adv_SLmouseover: function(handler) {
        this._adv.remove_SLmouseover(handler);
    },
    add_adv_SLkeydown: function(handler) {
        this._adv.add_SLkeydown(handler);
    },
    remove_adv_SLkeydown: function(handler) {
        this._adv.remove_SLkeydown(handler);
    },
    add_adv_SLkeyup: function(handler) {
        this._adv.add_SLkeyup(handler);
    },
    remove_adv_SLkeyup: function(handler) {
        this._adv.remove_SLkeyup(handler);
    },
    add_adv_SLchange: function(handler) {
        this._adv.add_SLchange(handler);
    },
    remove_adv_SLchange: function(handler) {
        this._adv.remove_SLchange(handler);
    },
    add_adv_SLfocus: function(handler) {
        this._adv.add_SLfocus(handler);
    },
    remove_adv_SLfocus: function(handler) {
        this._adv.remove_SLfocus(handler);
    },
    add_adv_SLblur: function(handler) {
        this._adv.add_SLblur(handler);
    },
    remove_adv_SLblur: function(handler) {
        this._adv.remove_SLblur(handler);
    },
    add_adv_SLclick: function(handler) {
        this._adv.add_SLclick(handler);
    },
    remove_adv_SLclick: function(handler) {
        this._adv.remove_SLclick(handler);
    },

    add_cand_click: function(handler) {
        this._adv.add_click(handler);
    },
    remove_cand_click: function(handler) {
        this._adv.remove_click(handler);
    },
    add_cand_hover: function(handler) {
        this._adv.add_hover(handler);
    },
    remove_cand_hover: function(handler) {
        this._adv.remove_hover(handler);
    },
    add_cand_unhover: function(handler) {
        this._adv.add_unhover(handler);
    },
    remove_cand_unhover: function(handler) {
        this._adv.remove_unhover(handler);
    },
    add_seg_click: function(handler) {
        this._adv.add_spclick(handler);
    },
    remove_seg_click: function(handler) {
        this._adv.remove_spclick(handler);
    },
    add_seg_hover: function(handler) {
        this._adv.add_sphover(handler);
    },
    remove_seg_hover: function(handler) {
        this._adv.remove_sphover(handler);
    },
    add_seg_unhover: function(handler) {
        this._adv.add_spunhover(handler);
    },
    remove_seg_unhover: function(handler) {
        this._adv.remove_spunhover(handler);
    },
    
    add_title_click: function(handler) {
        this._adv.add_titleclick(handler);
    },
    remove_title_click: function(handler) {
        this._adv.remove_titleclick(handler);
    },
    
    add_clear_click: function(handler) {
        this._adv.add_clearclick(handler);
    },
    remove_clear_click: function(handler) {
        this._adv.remove_clearclick(handler);
    },


    // Release resources before control is disposed.
    dispose: function() {
        //need not call the dispose function of this._normal(this._adv) The component will call it by itself.
        //this._normal.dispose();
        //this._adv.dispose();
        View.XiaLianView.callBaseMethod(this, "dispose");
    },

    initialize: function() {
        //handle normal candidate click event in advanced component.
        //this.add_normal_click(this._adv.on_normal_click);
        //this.add_cand_click(this._normal.on_cand_click)

        View.XiaLianView.callBaseMethod(this, "initialize");

    }
    
}
View.XiaLianView.registerClass("View.XiaLianView", Sys.UI.Control);

// Since this script is not loaded by System.Web.Handlers.ScriptResourceHandler
// invoke Sys.Application.notifyScriptLoaded to notify ScriptManager 
// that this is the end of the script.
if (typeof(Sys) !== "undefined") Sys.Application.notifyScriptLoaded();
